/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.common;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeMod;
import team.creative.itemphysic.ItemPhysic;

public class CommonPhysic {
    public static Fluid getFluid(ItemEntity item) {
        return CommonPhysic.getFluid(item, false);
    }

    public static Fluid getFluid(ItemEntity item, boolean below) {
        FluidState state;
        Fluid fluid;
        if (item.field_70170_p == null) {
            return null;
        }
        double d0 = item.func_226278_cu_();
        BlockPos pos = item.func_233580_cy_();
        if (below) {
            pos = pos.func_177977_b();
        }
        if ((fluid = (state = item.field_70170_p.func_204610_c(pos)).func_206886_c()) == null || fluid.getFluid().getAttributes().getDensity() == 0) {
            return null;
        }
        if (below) {
            return fluid;
        }
        double filled = state.func_215679_a((IBlockReader)item.field_70170_p, pos);
        if (d0 - (double)pos.func_177956_o() - 0.2 <= filled) {
            return fluid;
        }
        return null;
    }

    public static double getReachDistance(PlayerEntity player) {
        if (ItemPhysic.CONFIG.pickup.maximumPickupRange != 5.0f) {
            return ItemPhysic.CONFIG.pickup.maximumPickupRange;
        }
        float attrib = (float)player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        return player.func_184812_l_() ? (double)attrib : (double)(attrib - 0.5f);
    }

    public static RayTraceResult getEntityItem(PlayerEntity player, Vector3d position, Vector3d look, double distance) {
        float f1 = 3.0f;
        Vector3d include = look.func_178788_d(position);
        List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(include.field_72450_a, include.field_72448_b, include.field_72449_c).func_72321_a((double)f1, (double)f1, (double)f1));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof ItemEntity)) continue;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g(0.2);
            Optional vec = axisalignedbb.func_216365_b(position, look);
            if (vec.isPresent()) {
                return new EntityRayTraceResult(entity, (Vector3d)vec.get());
            }
            if (!axisalignedbb.func_72318_a(position)) continue;
            return new EntityRayTraceResult(entity);
        }
        return null;
    }
}

